<?php
include_once("Model.inc.php");

class Exercise extends Model{

    public $exerciseId;
    public $workoutId;
    public $exerciseName;
    public $sets;
    public $weight;
    public $repetitions;
    public $notes;


    public function __construct($args = []){
        $this->exerciseId = $args['exerciseId'] ?? 0;
        $this->workoutId = $args['workoutId'] ?? 0;
        $this->exerciseName = $args['exerciseName'] ?? "";
        $this->sets = $args['sets'] ?? 0;
        $this->weight = $args['weight'] ?? 0;
        $this->repetitions = $args['repetitions'] ?? 0;
        $this->notes = $args['notes'] ?? "";
    }

    public function isValid(){
        $valid = true;
        $this->validationErrors = [];

        if(!is_numeric($this->exerciseId) || $this->exerciseId < 0){
            $valid = false;
            $this->validationErrors['id'] = "ID is not valid";
        }

        if(!is_numeric($this->workoutId) || $this->workoutId < 0){
            $valid = false;
            $this->validationErrors['workoutId'] = "workoutID is not valid";
        }

        if(empty($this->exerciseName)){
            $valid = false;
            $this->validationErrors['exerciseName'] = "Exercise Name is required";
        }else if(strlen($this->exerciseName) > 30){
            $valid = false;
            $this->validationErrors['exerciseName'] = "Exercise Name must be 30 characters or less";
        }

        if(!is_numeric($this->sets)){
            $valid = false;
            $this->validationErrors['sets'] = "Sets are required";
        }

        if(!is_numeric($this->weight)){
            $valid = false;
            $this->validationErrors['weight'] = "weight is required";
        }

        if(!is_numeric($this->repetitions)){
            $valid = false;
            $this->validationErrors['repetitions'] = "repetitions are required";
        }

        if(empty($this->notes)){
            $valid = false;
            $this->validationErrors['notes'] = "Notes required";
        }else if(strlen($this->notes) > 120){
            $valid = false;
            $this->validationErrors['notes'] = "Notes must be 30 characters or less";
        }


        




        return $valid;
    }
}