<?php

include_once("DataAccess.inc.php");
include_once(__DIR__ . "/../models/Workout.inc.php");

class WorkoutDataAccess extends DataAccess{
    function __construct($link){
        parent::__construct($link);
    }

    function convertModelToRow($workout){
        $row = [];
        $row["workout_id"] = $workout->workoutId;
        $row["user_id"] = $workout->userId;
        $row["workout_name"] = $workout->workoutName;
        $row["notes"] = $workout->notes;

        return $row;
    }

    function convertRowToModel($row){
        $workout = new Workout();
        $workout->workoutId = $row['workout_id'];
        $workout->userId = $row['user_id'];
        $workout->workoutName = $row['workout_name'];
        $workout->notes = $row['notes'];

        return $workout;
    }

    function getAll($args = []){
        $qStr = "SELECT
            workout_id,
            user_id,
            workout_name,
            notes
            FROM workout";

        $result = mysqli_query($this->link, $qStr) or $this->handleError(mysqli_error($this->link));
        
        $allWorkouts = [];

        while($row = mysqli_fetch_assoc($result)){
            $allWorkouts[] = $this->convertRowToModel($row);
        }

        return $allWorkouts;
    }

    function getById($id){
        $qStr = "SELECT
            workout_id,
            user_id,
            workout_name,
            notes
            FROM workout
            WHERE workout_id =" . mysqli_real_escape_string($this->link, $id);

        $result = mysqli_query($this->link, $qStr) or $this->handleError(mysqli_error($this->link));

        if($result->num_rows ==1){
            $row = mysqli_fetch_assoc($result);

            $workout = $this->convertRowToModel($row);
            return $workout;
        }

        return false;
    }

    function insert($workout){
        $row = $this->convertModelToRow($workout);

        $qStr = "INSERT INTO workout (
            user_id,
            workout_name,
            notes
            ) VALUES(
                '{$row['user_id']}',
                '{$row['workout_name']}',
                '{$row['notes']}'
            )";

        $result = mysqli_query($this->link, $qStr) or $this->handleError(mysqli_error($this->link));
            
        if($result){
            $workout->workoutId = mysqli_insert_id($this->link);
            return $workout;
        }else{
            $this->handleError("unable to insert workout");
        }

        return false;

    }

    function update($workout){
        $row = $this->convertModelToRow($workout);

        $qStr;

        $qStr = "UPDATE workout SET
                user_id = '{$row['user_id']}',
                workout_name = '{$row['workout_name']}',
                notes = '{$row['notes']}'
            WHERE workout_id = " . $row['workout_id'];
            
		$result = mysqli_query($this->link, $qStr) or $this->handleError(mysqli_error($this->link));
        
        if($result){
            return true;
        }else{
            $this->handleError("Unable to update workout");
        }

        return false;
    }

    function delete($args = null){
        return null;
    }
}